<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('interview_preparation', function (Blueprint $table) {
            $table->text('Feedback')->nullable()->after('Is_completed');
            $table->unsignedBigInteger('Job_id')->nullable()->after('Feedback');
            $table->index('Job_id', 'interview_preparation_job_id_index');
            $table->foreign('Job_id', 'interview_preparation_job_id_foreign')
                  ->references('Job_id')->on('jobs')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('interview_preparation', function (Blueprint $table) {
            $table->dropForeign(['Job_id']);
            $table->dropIndex('interview_preparation_job_id_index');
            $table->dropColumn(['Feedback', 'Job_id']);
        });
    }
};
